#!/bin/bash

for file in *.png; do
  [ -e "$file" ] || continue

  size=$(identify -format "%w" "$file")
  output="circle_${file}"

  cx=$((size / 2))
  cy=$((size / 2))

  radius=$((cx - 4))

  convert -size ${size}x${size} xc:none -fill white \
    -draw "circle $cx,$cy $((cx)),$((cy - radius))" \
    mask.png

  convert "$file" mask.png -alpha off -compose CopyOpacity -composite "$output"

  echo "Processed $file -> $output"
done

rm -f mask.png
